/*
 * Decompiled with CFR 0.152.
 */
package scientific;

import com.nokia.mid.appl.calc2.Local;
import common.control.DisplayManager;
import common.ui.DisplaySizes;
import common.ui.EditPanel;
import common.util.Tools;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import scientific.BinaryOperator;
import scientific.Number;
import scientific.Parenthesis;
import scientific.Parser;
import scientific.Symbol;
import scientific.UnaryOperator;

public final class ScientificEditPanel
extends EditPanel {
    private static final int DOUGLAS_8_WIDTH = 236;
    private static final int DOUGLAS_8_HEIGHT = 122;
    private static final int S60_3_1_HEIGHT = 110;
    private static final int DOUGLAS_8_X_POS = 2;
    private static final int DOUGLAS_8_Y_POS = 2;
    private static final int DOUGLAS_8_MEMORY_STATUS_SYMBOL_X_POS = 60;
    private static final int DOUGLAS_8_DEGREES_RADIAN_STATUS_SYMBOL_X_POS = 9;
    private static final int DOUGLAS_8_PARENTHESES_STATUS_SYMBOL_X_POS = 94;
    private static final int DOUGLAS_8_DOWN_ARROW_STATUS_SYMBOL_X_POS = 210;
    private static final int DOUGLAS_8_UP_ARROW_STATUS_SYMBOL_X_POS = 222;
    private static final int DOUGLAS_8_UP_DOWN_ARROW_STATUS_SYMBOL_Y_POS_OFFSET = 10;
    private static final int DOUGLAS_8_TERM_MAXIMUM_WIDTH = 230;
    private static final int DOUGLAS_8_TERM_X_POS = 6;
    private static final int DOUGLAS_8_TERM_Y_POS = 20;
    private static final int DOUGLAS_8_TERM_Y_SPACING = -2;
    private static final int DOUGLAS_8_RESULT_LINE_X_POS_1 = 7;
    private static final int DOUGLAS_8_RESULT_LINE_X_POS_2 = 232;
    private static final int DOUGLAS_8_RESULT_LINE_Y_POS = 96;
    private static final int S60_RESULT_LINE_Y_POS = 86;
    private static final int DOUGLAS_8_RESULT_OPERATOR_X_POS = 8;
    private static final int DOUGLAS_8_RESULT_OPERATOR_Y_POS = 98;
    private static final int S60_RESULT_OPERATOR_Y_POS = 88;
    private static final int DOUGLAS_8_RESULT_X_POS = 232;
    private static final int DOUGLAS_8_RESULT_Y_POS = 98;
    private static final int S60_RESULT_Y_POS = 88;
    private static final int S60_3_2_LS_RESULT_LINE_Y_POS = 78;
    private static final int S60_3_2_LS_RESULT_OPERATOR_Y_POS = 78;
    private static final int S60_3_2_LS_RESULT_Y_POS = 78;
    private static final int DOUGLAS_8_MAXIMUM_NUMBER_OF_CONCURRENTLY_VISIBLE_ROWS = 4;
    private static final int MAXIMUM_NUMBER_OF_SYMBOLS = 100;
    private static final int STATE_TERM = 0;
    private static final int STATE_RESULT = 1;
    private static final int S60_3_2_LANDSCAPE_HEIGHT = 100;
    private boolean useDegrees = true;
    private int degreesRadianStatusSymbolXPos = 0;
    private int openParentheses = 0;
    private int parenthesesStatusSymbolXPos = 0;
    private final Sprite arrowStatusSymbol;
    private int downArrowStatusSymbolXPos = 0;
    private int upArrowStatusSymbolXPos = 0;
    private int termMaximumWidth = 0;
    private int termXPos = 0;
    private int termYPos = 0;
    private int termYSpacing = 0;
    private int maximumNumberOfConcurrentlyVisibleRows = 0;
    private Vector term = new Vector();
    private String result = null;
    private Vector rows = new Vector();
    private int currentRowIndex = 0;
    private int firstVisibleRowIndex = 0;
    private int lastVisibleRowIndex = 0;
    private int resultLineXPos1 = 0;
    private int resultLineXPos2 = 0;
    private int resultLineYPos = 0;
    private int resultOperatorXPos = 0;
    private int resultOperatorYPos = 0;
    private int resultXPos = 0;
    private int resultYPos = 0;

    public ScientificEditPanel(DisplaySizes displaySize) {
        super(displaySize);
        Image arrowsImage = Tools.getInstance().loadImage("/images/arrow_large_status.png");
        this.arrowStatusSymbol = new Sprite(arrowsImage);
        if (displaySize == DisplaySizes.DOUGLAS_8) {
            this.width = 236;
            this.height = 122;
            this.xPos = 2;
            this.yPos = 2;
            this.font = Font.getFont((int)0, (int)0, (int)16);
            this.memoryStatusSymbolXPos = 60;
            this.degreesRadianStatusSymbolXPos = 9;
            this.parenthesesStatusSymbolXPos = 94;
            this.downArrowStatusSymbolXPos = 210;
            this.upArrowStatusSymbolXPos = 222;
            this.termMaximumWidth = 230;
            this.termXPos = 6;
            this.termYPos = 20;
            this.termYSpacing = -2;
            this.resultLineXPos1 = 7;
            this.resultLineXPos2 = 232;
            this.resultLineYPos = 96;
            this.resultOperatorXPos = 8;
            this.resultOperatorYPos = 98;
            this.resultXPos = 232;
            this.resultYPos = 98;
            this.maximumNumberOfConcurrentlyVisibleRows = 4;
        } else if (displaySize == DisplaySizes.S60_3_1 || displaySize == DisplaySizes.S60_3_2_SDK || displaySize == DisplaySizes.S60_3_2) {
            this.width = 236;
            this.height = 122;
            this.xPos = 2;
            this.yPos = 2;
            this.font = Font.getFont((int)0, (int)0, (int)16);
            this.memoryStatusSymbolXPos = 60;
            this.degreesRadianStatusSymbolXPos = 9;
            this.parenthesesStatusSymbolXPos = 94;
            this.downArrowStatusSymbolXPos = 210;
            this.upArrowStatusSymbolXPos = 222;
            this.termMaximumWidth = 230;
            this.termXPos = 6;
            this.termYPos = 20;
            this.termYSpacing = -2;
            this.resultLineXPos1 = 7;
            this.resultLineXPos2 = 232;
            this.resultLineYPos = 96;
            this.resultOperatorXPos = 8;
            this.resultOperatorYPos = 98;
            this.resultXPos = 232;
            this.resultYPos = 98;
            this.maximumNumberOfConcurrentlyVisibleRows = 4;
        } else if (displaySize == DisplaySizes.S60_3_1_OLD) {
            this.width = 236;
            this.height = 110;
            this.xPos = 2;
            this.yPos = 2;
            this.font = Font.getFont((int)0, (int)0, (int)16);
            this.memoryStatusSymbolXPos = 60;
            this.degreesRadianStatusSymbolXPos = 9;
            this.parenthesesStatusSymbolXPos = 94;
            this.downArrowStatusSymbolXPos = 210;
            this.upArrowStatusSymbolXPos = 222;
            this.termMaximumWidth = 230;
            this.termXPos = 6;
            this.termYPos = 20;
            this.termYSpacing = -2;
            this.resultLineXPos1 = 7;
            this.resultLineXPos2 = 232;
            this.resultLineYPos = 86;
            this.resultOperatorXPos = 8;
            this.resultOperatorYPos = 88;
            this.resultXPos = 232;
            this.resultYPos = 88;
            this.maximumNumberOfConcurrentlyVisibleRows = 4;
        } else if (displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || displaySize == DisplaySizes.TUBE_LANDSCAPE_GAME || displaySize == DisplaySizes.TUBE_PORTRAIT_GAME || displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
            this.width = 236;
            this.height = 100;
            this.xPos = 2;
            this.yPos = 2;
            this.font = Font.getFont((int)0, (int)0, (int)16);
            this.memoryStatusSymbolXPos = 60;
            this.degreesRadianStatusSymbolXPos = 9;
            this.parenthesesStatusSymbolXPos = 94;
            this.downArrowStatusSymbolXPos = 210;
            this.upArrowStatusSymbolXPos = 222;
            this.termMaximumWidth = 230;
            this.termXPos = 6;
            this.termYPos = 20;
            this.termYSpacing = -2;
            this.resultLineXPos1 = 7;
            this.resultLineXPos2 = 232;
            this.resultLineYPos = 78;
            this.resultOperatorXPos = 8;
            this.resultOperatorYPos = 78;
            this.resultXPos = 232;
            this.resultYPos = 78;
            this.maximumNumberOfConcurrentlyVisibleRows = 4;
        }
        this.initEditPanel();
    }

    public void paint(Graphics g) {
        if (this.displaySize == DisplaySizes.DOUGLAS_8 || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK) {
            this.font = Font.getFont((int)0, (int)0, (int)16);
        } else if (this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_GAME || this.displaySize == DisplaySizes.TUBE_PORTRAIT_GAME || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
            this.font = Font.getFont((int)0, (int)0, (int)16);
        }
        super.paint(g);
        this.drawStatusSymbols(g);
        this.drawTerm(g);
        this.drawResult(g);
    }

    private int checkKeyCode(int keyCode) {
        int key = keyCode;
        if (key > 57 && key != 107 && key != 105) {
            int[] codes = new int[]{109, 114, 116, 121, 102, 103, 104, 118, 98, 110};
            boolean found = false;
            int i = 0;
            while (!found) {
                if (key != codes[i]) {
                    ++i;
                    continue;
                }
                key = 48 + i;
                found = true;
            }
        }
        return key;
    }

    public void keyPressed(int keyCode, int gameAction) {
        super.keyPressed(keyCode, gameAction);
        int key = this.checkKeyCode(keyCode);
        if (this.currentState == 0) {
            if (keyCode == 35 || keyCode == 106) {
                this.handlePressedButton(20);
            } else if (keyCode == 105) {
                this.handlePressedButton(0);
            } else if (keyCode == 107) {
                this.handlePressedButton(1);
            } else if (keyCode >= 48 && keyCode <= 57 || keyCode >= 98 && keyCode != 117 && keyCode != 228) {
                this.addDigit(String.valueOf((char)key));
            }
        } else if (this.currentState == 1) {
            if (keyCode >= 48 && keyCode <= 57) {
                this.initEditPanel();
                this.keyPressed(keyCode, gameAction);
            } else if (keyCode == 35) {
                this.handlePressedButton(20);
            }
        }
    }

    public void handlePressedButton(int buttonType) {
        if (this.currentState == 0) {
            switch (buttonType) {
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 17: 
                case 18: {
                    this.addUnaryOperator(buttonType);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 16: {
                    this.addBinaryOperator(buttonType);
                    break;
                }
                case 8: {
                    this.doReciprocal();
                    break;
                }
                case 5: {
                    this.calcPercentage();
                    break;
                }
                case 4: {
                    this.calcTerm();
                    break;
                }
                case 20: {
                    this.addDigit(".");
                    break;
                }
                case 21: {
                    this.changeSign();
                    break;
                }
                case 19: {
                    this.addPi();
                    break;
                }
                case 22: {
                    this.addParenthesis(Parenthesis.LEFT);
                    break;
                }
                case 23: {
                    this.addParenthesis(Parenthesis.RIGHT);
                    break;
                }
                case 24: {
                    this.initEditPanel();
                    break;
                }
                case 25: {
                    this.saveToMemory();
                    break;
                }
                case 26: {
                    this.recallFromMemory();
                    break;
                }
                case 27: {
                    this.scrollUp();
                    break;
                }
                case 28: {
                    this.scrollDown();
                }
            }
        } else if (this.currentState == 1) {
            switch (buttonType) {
                case 15: {
                    this.initEditPanel();
                    this.addNewNumber(this.result);
                    this.addUnaryOperator(buttonType);
                    break;
                }
                case 7: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: 
                case 18: {
                    this.initEditPanel();
                    this.addUnaryOperator(buttonType);
                    this.addSymbol(new Number(this.result));
                    this.addParenthesis(Parenthesis.RIGHT);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 16: {
                    this.initEditPanel();
                    this.addNewNumber(this.result);
                    this.addBinaryOperator(buttonType);
                    break;
                }
                case 8: {
                    this.initEditPanel();
                    this.addNewNumber(this.result);
                    this.doReciprocal();
                    break;
                }
                case 5: {
                    this.initEditPanel();
                    this.addNewNumber(this.result);
                    this.calcPercentage();
                    break;
                }
                case 20: {
                    this.initEditPanel();
                    if (this.result.indexOf(".") < 0) {
                        this.addNewNumber(this.result);
                        this.addDigit(".");
                        break;
                    }
                    this.addNewNumber(this.result);
                    break;
                }
                case 21: {
                    this.initEditPanel();
                    this.addNewNumber(this.result);
                    this.changeSign();
                    break;
                }
                case 19: {
                    this.initEditPanel();
                    this.addPi();
                    break;
                }
                case 22: {
                    this.initEditPanel();
                    this.addParenthesis(Parenthesis.LEFT);
                    this.addNewNumber(this.result);
                    break;
                }
                case 23: {
                    this.initEditPanel();
                    this.addParenthesis(Parenthesis.LEFT);
                    this.addNewNumber(this.result);
                    this.addParenthesis(Parenthesis.RIGHT);
                    break;
                }
                case 24: {
                    this.initEditPanel();
                    break;
                }
                case 25: {
                    this.saveToMemory();
                    break;
                }
                case 26: {
                    this.initEditPanel();
                    this.recallFromMemory();
                }
            }
        }
    }

    public void removeLastSymbol() {
        if (this.currentState == 0) {
            if (this.term.size() <= 0) {
                return;
            }
            Symbol lastSymbol = (Symbol)this.term.lastElement();
            if (lastSymbol == null) {
                return;
            }
            if (lastSymbol instanceof Number) {
                this.removeLastSymbolFromRowsVector();
                this.term.removeElement(lastSymbol);
                if (!((Number)lastSymbol).removeLastDigit()) {
                    this.addSymbol(lastSymbol);
                }
                if (this.rows.size() > this.maximumNumberOfConcurrentlyVisibleRows - 1) {
                    this.scrollToLastRow();
                }
                if (this.term.size() == 0) {
                    this.initEditPanel();
                }
                this.repaint();
                return;
            }
            if (lastSymbol.equals(Parenthesis.LEFT)) {
                --this.openParentheses;
            } else if (lastSymbol.equals(Parenthesis.RIGHT)) {
                ++this.openParentheses;
            }
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            if (this.rows.size() > this.maximumNumberOfConcurrentlyVisibleRows - 1) {
                this.scrollToLastRow();
            }
            if (this.term.size() == 0) {
                this.initEditPanel();
            }
        } else if (this.currentState == 1) {
            this.changeState(0);
            this.scrollToLastRow();
        }
        this.repaint();
    }

    void setUseDegrees(boolean useDegrees) {
        this.useDegrees = useDegrees;
    }

    boolean isUseDegrees() {
        return this.useDegrees;
    }

    protected void initEditPanel() {
        this.term.removeAllElements();
        this.initRowsVector();
        if (this.calculatorCanvas != null) {
            this.calculatorCanvas.removeClearCommand();
        }
        this.openParentheses = 0;
        this.changeState(0);
    }

    protected void saveToMemory() {
        if (this.currentState == 0) {
            Symbol lastSymbol = this.getNthLastSymbol(1);
            Symbol secondLastSymbol = this.getNthLastSymbol(2);
            Symbol thirdLastSymbol = this.getNthLastSymbol(3);
            String value = null;
            if (lastSymbol == null) {
                return;
            }
            if (lastSymbol instanceof Number) {
                value = lastSymbol.getValue();
            } else if (lastSymbol.equals(Parenthesis.RIGHT) && secondLastSymbol instanceof Number && thirdLastSymbol.equals(Parenthesis.LEFT)) {
                value = secondLastSymbol.getValue();
            }
            if (value != null) {
                if (value.equals("0") || value.equals("-0")) {
                    this.memory = null;
                    this.memoryDirty = false;
                } else {
                    this.memory = value;
                    this.memoryDirty = true;
                }
            }
        } else if (this.currentState == 1 && this.result != null) {
            if (this.result.equals("0") || this.result.equals("-0")) {
                this.memory = null;
                this.memoryDirty = false;
            } else {
                this.memory = this.result;
                this.memoryDirty = true;
            }
        }
    }

    protected boolean recallFromMemory() {
        if (this.memory == null || this.memory.length() == 0) {
            return false;
        }
        if (this.currentState == 0) {
            Symbol lastSymbol = this.getNthLastSymbol(1);
            if (lastSymbol instanceof Number) {
                this.removeLastSymbolFromRowsVector();
                this.term.removeElement(lastSymbol);
            }
            this.addNewNumber(this.memory);
        } else if (this.currentState == 1) {
            this.initEditPanel();
            this.addNewNumber(this.memory);
        }
        this.repaint();
        return true;
    }

    protected void changeState(int newState) {
        if (newState < 0 && newState > 1) {
            return;
        }
        this.currentState = newState;
    }

    private boolean addSymbol(Symbol symbol) {
        if (symbol == null) {
            return false;
        }
        if (symbol != Parenthesis.RIGHT && this.term.size() + this.openParentheses >= 100) {
            Alert alert = new Alert(Local.getText(28), Local.getText(7), null, AlertType.INFO);
            DisplayManager.getInstance().push(alert);
            return false;
        }
        this.term.addElement(symbol);
        this.addLastSymbolToRowsVector();
        if (this.currentRowIndex > this.maximumNumberOfConcurrentlyVisibleRows - 1) {
            this.scrollToLastRow();
        }
        if (this.term.size() == 1 && this.calculatorCanvas != null) {
            this.calculatorCanvas.addClearCommand();
        }
        return true;
    }

    private void addUnaryOperator(int buttonType) {
        Symbol lastSymbol = this.getNthLastSymbol(1);
        switch (buttonType) {
            case 7: {
                this.addSymbol(new UnaryOperator(1));
                this.addParenthesis(Parenthesis.LEFT);
                break;
            }
            case 9: {
                this.addSymbol(new UnaryOperator(2));
                this.addParenthesis(Parenthesis.LEFT);
                break;
            }
            case 10: {
                this.addSymbol(new UnaryOperator(3));
                this.addParenthesis(Parenthesis.LEFT);
                break;
            }
            case 11: {
                this.addSymbol(new UnaryOperator(4));
                this.addParenthesis(Parenthesis.LEFT);
                break;
            }
            case 12: {
                this.addSymbol(new UnaryOperator(5));
                this.addParenthesis(Parenthesis.LEFT);
                break;
            }
            case 13: {
                this.addSymbol(new UnaryOperator(6));
                this.addParenthesis(Parenthesis.LEFT);
                break;
            }
            case 14: {
                this.addSymbol(new UnaryOperator(7));
                this.addParenthesis(Parenthesis.LEFT);
                break;
            }
            case 15: {
                if (lastSymbol instanceof Number) {
                    this.addSymbol(new UnaryOperator(8));
                    break;
                }
                if (!(lastSymbol instanceof Parenthesis) || !lastSymbol.equals(Parenthesis.RIGHT)) break;
                this.addSymbol(new UnaryOperator(8));
                break;
            }
            case 17: {
                this.addSymbol(new UnaryOperator(9));
                this.addParenthesis(Parenthesis.LEFT);
                break;
            }
            case 18: {
                this.addSymbol(new UnaryOperator(10));
                this.addParenthesis(Parenthesis.LEFT);
            }
        }
    }

    private void addBinaryOperator(int buttonType) {
        Symbol lastSymbol = this.getNthLastSymbol(1);
        Symbol secondLastSymbol = this.getNthLastSymbol(2);
        if (lastSymbol == null) {
            return;
        }
        if (lastSymbol instanceof Number) {
            this.addBinaryOperatorHelper(buttonType);
        } else if (lastSymbol.equals(Parenthesis.RIGHT)) {
            this.addBinaryOperatorHelper(buttonType);
        } else if (lastSymbol.equals(Parenthesis.LEFT) && buttonType == 1) {
            this.addBinaryOperatorHelper(buttonType);
        } else if (lastSymbol instanceof UnaryOperator) {
            if (lastSymbol.getValue().equals("^2") || lastSymbol.getValue().equals("!")) {
                this.addBinaryOperatorHelper(buttonType);
            }
        } else if (lastSymbol instanceof BinaryOperator) {
            if (lastSymbol.getId() == 1 && secondLastSymbol != null && secondLastSymbol.equals(Parenthesis.LEFT)) {
                return;
            }
            this.removeLastSymbolFromRowsVector();
            this.term.removeElement(lastSymbol);
            this.addBinaryOperator(buttonType);
        }
    }

    private void addBinaryOperatorHelper(int buttonType) {
        switch (buttonType) {
            case 0: {
                this.addSymbol(new BinaryOperator(0));
                break;
            }
            case 1: {
                this.addSymbol(new BinaryOperator(1));
                break;
            }
            case 2: {
                this.addSymbol(new BinaryOperator(2));
                break;
            }
            case 3: {
                this.addSymbol(new BinaryOperator(3));
                break;
            }
            case 16: {
                this.addSymbol(new BinaryOperator(4));
                break;
            }
            case 6: {
                this.addSymbol(new BinaryOperator(4));
                this.addNewNumber("2");
            }
        }
    }

    private void addNewNumber(String number) {
        Number newNumber = new Number(number);
        if (newNumber.isNegative()) {
            this.addParenthesis(Parenthesis.LEFT);
            this.addSymbol(newNumber);
            this.addParenthesis(Parenthesis.RIGHT);
        } else {
            this.addSymbol(newNumber);
        }
    }

    private void addDigit(String digit) {
        Symbol lastSymbol = this.getNthLastSymbol(1);
        if (lastSymbol == null || !(lastSymbol instanceof Number)) {
            this.addNewNumber(digit);
        } else if (lastSymbol instanceof Number) {
            this.removeLastSymbolFromRowsVector();
            Number lastNumber = (Number)lastSymbol;
            lastNumber.addDigit(digit);
            this.term.removeElement(lastSymbol);
            this.addSymbol(lastSymbol);
            if (this.currentRowIndex > this.maximumNumberOfConcurrentlyVisibleRows - 1) {
                this.scrollToLastRow();
            }
        }
    }

    private void addPi() {
        Symbol lastSymbol = this.getNthLastSymbol(1);
        if (lastSymbol instanceof Number) {
            Number lastNumber = (Number)lastSymbol;
            if (lastNumber.getValue().equals("0") || lastNumber.getValue().equals("-")) {
                this.removeLastSymbolFromRowsVector();
                this.term.removeElement(lastNumber);
                this.addNewNumber("\u03c0");
                return;
            }
            this.addBinaryOperator(2);
        }
        this.addNewNumber("\u03c0");
    }

    private void addParenthesis(Parenthesis parenthesisType) {
        if (parenthesisType.equals(Parenthesis.LEFT)) {
            if (this.addSymbol(parenthesisType)) {
                ++this.openParentheses;
            }
        } else if (parenthesisType.equals(Parenthesis.RIGHT)) {
            if (this.term.size() >= 100 && this.openParentheses == 0) {
                Alert alert = new Alert(Local.getText(28), Local.getText(7), null, AlertType.INFO);
                DisplayManager.getInstance().push(alert);
            }
            if (this.openParentheses > 0 && this.addSymbol(parenthesisType)) {
                --this.openParentheses;
            }
        }
    }

    private void doReciprocal() {
        Symbol lastSymbol = this.getNthLastSymbol(1);
        Symbol secondLastSymbol = this.getNthLastSymbol(2);
        Symbol thirdLastSymbol = this.getNthLastSymbol(3);
        Symbol fourthLastSymbol = this.getNthLastSymbol(4);
        Symbol fifthLastSymbol = this.getNthLastSymbol(5);
        Symbol sixthLastSymbol = this.getNthLastSymbol(6);
        Symbol seventhLastSymbol = this.getNthLastSymbol(7);
        if (lastSymbol == null) {
            this.addNewNumber("1");
            this.addBinaryOperator(3);
        } else if (lastSymbol instanceof Number) {
            this.removeLastSymbolFromRowsVector();
            this.term.removeElement(lastSymbol);
            this.addParenthesis(Parenthesis.LEFT);
            this.addNewNumber("1");
            this.addBinaryOperator(3);
            this.addNewNumber(lastSymbol.getValue());
            this.addParenthesis(Parenthesis.RIGHT);
        } else if (lastSymbol.equals(Parenthesis.RIGHT) && secondLastSymbol instanceof Number && thirdLastSymbol.equals(Parenthesis.LEFT)) {
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.addSymbol(secondLastSymbol);
            this.doReciprocal();
        } else if (lastSymbol.equals(Parenthesis.RIGHT) && secondLastSymbol instanceof Number && thirdLastSymbol instanceof BinaryOperator && fourthLastSymbol instanceof Number && fifthLastSymbol.equals(Parenthesis.LEFT)) {
            if (thirdLastSymbol.getId() != 3) {
                return;
            }
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.addNewNumber(secondLastSymbol.getValue());
        } else if (lastSymbol.equals(Parenthesis.RIGHT) && secondLastSymbol.equals(Parenthesis.RIGHT) && thirdLastSymbol instanceof Number && fourthLastSymbol.equals(Parenthesis.LEFT) && fifthLastSymbol instanceof BinaryOperator && sixthLastSymbol instanceof Number && seventhLastSymbol.equals(Parenthesis.LEFT)) {
            if (fifthLastSymbol.getId() != 3) {
                return;
            }
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.addNewNumber(thirdLastSymbol.getValue());
        } else {
            this.addNewNumber("1");
            this.addBinaryOperator(3);
        }
    }

    private void calcPercentage() {
        Symbol lastSymbol = this.getNthLastSymbol(1);
        Symbol secondLastSymbol = this.getNthLastSymbol(2);
        Symbol thirdLastSymbol = this.getNthLastSymbol(3);
        if (lastSymbol == null) {
            return;
        }
        if (lastSymbol instanceof Number) {
            this.removeLastSymbolFromRowsVector();
            ((Number)lastSymbol).calcPercentage();
            this.term.removeElement(lastSymbol);
            this.addSymbol(lastSymbol);
        } else if (lastSymbol.equals(Parenthesis.RIGHT) && secondLastSymbol instanceof Number && thirdLastSymbol.equals(Parenthesis.LEFT)) {
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            Number number = (Number)secondLastSymbol;
            number.calcPercentage();
            this.addNewNumber(number.value);
        }
    }

    private void calcTerm() {
        if (this.term.size() == 0) {
            return;
        }
        if (this.openParentheses > 0) {
            Alert alert = new Alert(Local.getText(28), Local.getText(10), null, AlertType.INFO);
            DisplayManager.getInstance().push(alert);
            return;
        }
        double resultValue = 0.0;
        try {
            Parser parser = new Parser(this.term, this.useDegrees);
            resultValue = parser.parse();
        }
        catch (ArithmeticException e) {
            Alert alert = new Alert(Local.getText(28), e.getMessage(), null, AlertType.INFO);
            DisplayManager.getInstance().push(alert);
            return;
        }
        catch (IllegalStateException e) {
            Alert alert = new Alert(Local.getText(28), Local.getText(12), null, AlertType.INFO);
            DisplayManager.getInstance().push(alert);
            return;
        }
        this.result = null;
        this.result = Tools.getInstance().doubleToStringRounded(resultValue, 15);
        if (this.result == null) {
            String outOfRange = Local.getText(11, new String[]{String.valueOf(15)});
            Alert alert = new Alert(Local.getText(28), outOfRange, null, AlertType.INFO);
            DisplayManager.getInstance().push(alert);
            return;
        }
        if (this.result.equals("-0")) {
            this.result = "0";
        }
        this.changeState(1);
    }

    private void changeSign() {
        Symbol lastSymbol = this.getNthLastSymbol(1);
        Symbol secondLastSymbol = this.getNthLastSymbol(2);
        Symbol thirdLastSymbol = this.getNthLastSymbol(3);
        Symbol fourthLastSymbol = this.getNthLastSymbol(4);
        Symbol fifthLastSymbol = this.getNthLastSymbol(5);
        Symbol sixthLastSymbol = this.getNthLastSymbol(6);
        Symbol seventhLastSymbol = this.getNthLastSymbol(7);
        if (lastSymbol == null) {
            return;
        }
        if (lastSymbol instanceof Number) {
            Number lastNumber = (Number)lastSymbol;
            if (!lastNumber.isNegative() && lastNumber.isZero()) {
                return;
            }
            this.removeLastSymbolFromRowsVector();
            this.term.removeElement(lastNumber);
            if (lastNumber.changeSign()) {
                if (lastNumber.isNegative()) {
                    this.addParenthesis(Parenthesis.LEFT);
                    this.addSymbol(lastNumber);
                    this.addParenthesis(Parenthesis.RIGHT);
                } else {
                    this.addSymbol(lastNumber);
                }
            } else {
                this.addSymbol(lastNumber);
            }
        } else if (lastSymbol.equals(Parenthesis.RIGHT) && secondLastSymbol instanceof Number && thirdLastSymbol.equals(Parenthesis.LEFT)) {
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.addSymbol(secondLastSymbol);
            this.changeSign();
        } else if (lastSymbol.equals(Parenthesis.RIGHT) && secondLastSymbol instanceof Number && thirdLastSymbol instanceof BinaryOperator && fourthLastSymbol instanceof Number && fifthLastSymbol.equals(Parenthesis.LEFT)) {
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.changeSign();
            this.addSymbol(lastSymbol);
        } else if (lastSymbol.equals(Parenthesis.RIGHT) && secondLastSymbol.equals(Parenthesis.RIGHT) && thirdLastSymbol instanceof Number && fourthLastSymbol.equals(Parenthesis.LEFT) && fifthLastSymbol instanceof BinaryOperator && sixthLastSymbol instanceof Number && seventhLastSymbol.equals(Parenthesis.LEFT)) {
            this.removeLastSymbolFromRowsVector();
            this.term.removeElementAt(this.term.size() - 1);
            this.changeSign();
            this.addSymbol(lastSymbol);
        } else if (lastSymbol instanceof BinaryOperator) {
            if (lastSymbol.getId() == 0) {
                this.addBinaryOperator(1);
            } else if (lastSymbol.getId() == 1) {
                this.addBinaryOperator(0);
            }
        }
    }

    private void scrollUp() {
        if (this.rows.size() > this.maximumNumberOfConcurrentlyVisibleRows && this.firstVisibleRowIndex > 0) {
            --this.firstVisibleRowIndex;
            --this.lastVisibleRowIndex;
        }
    }

    private void scrollDown() {
        if (this.rows.size() > this.maximumNumberOfConcurrentlyVisibleRows && this.lastVisibleRowIndex < this.rows.size() - 1) {
            ++this.firstVisibleRowIndex;
            ++this.lastVisibleRowIndex;
        }
    }

    private void scrollToLastRow() {
        int numberOfNonVisibleRows = this.rows.size() - this.maximumNumberOfConcurrentlyVisibleRows;
        if (numberOfNonVisibleRows < 0) {
            return;
        }
        this.firstVisibleRowIndex = this.rows.size() - this.maximumNumberOfConcurrentlyVisibleRows;
        this.lastVisibleRowIndex = this.currentRowIndex;
    }

    private void initRowsVector() {
        this.rows.removeAllElements();
        this.rows.addElement(new StringBuffer());
        this.currentRowIndex = 0;
        this.firstVisibleRowIndex = 0;
        this.lastVisibleRowIndex = 0;
    }

    private void addLastSymbolToRowsVector() {
        Symbol lastSymbol = (Symbol)this.term.elementAt(this.term.size() - 1);
        if (lastSymbol == null) {
            return;
        }
        int rowWidth = this.font.stringWidth(this.getCurrentRow().toString()) + this.font.stringWidth(lastSymbol.getValue());
        if (rowWidth > this.termMaximumWidth) {
            this.rows.addElement(new StringBuffer());
            ++this.currentRowIndex;
        }
        this.getCurrentRow().append(lastSymbol.getValue());
    }

    private void removeLastSymbolFromRowsVector() {
        Symbol lastSymbol = (Symbol)this.term.elementAt(this.term.size() - 1);
        if (lastSymbol == null) {
            return;
        }
        int numberOfCharactersInLastSymbol = lastSymbol.toString().length();
        int numberOfCharactersInCurrentRow = this.getCurrentRow().toString().length();
        if (numberOfCharactersInCurrentRow > numberOfCharactersInLastSymbol) {
            this.getCurrentRow().delete(numberOfCharactersInCurrentRow - numberOfCharactersInLastSymbol, numberOfCharactersInCurrentRow);
        } else {
            this.getCurrentRow().delete(numberOfCharactersInCurrentRow - numberOfCharactersInLastSymbol, numberOfCharactersInCurrentRow);
            if (this.currentRowIndex > 0) {
                this.rows.removeElementAt(this.currentRowIndex);
                --this.currentRowIndex;
            }
        }
    }

    private void drawStatusSymbols(Graphics g) {
        if (this.useDegrees) {
            if (this.displaySize == DisplaySizes.DOUGLAS_8 || this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD) {
                g.setFont(this.statusSymbolFont);
                g.drawString("DEG", this.degreesRadianStatusSymbolXPos, this.statusSymbolYPos + 1, 20);
                g.setFont(this.font);
            } else if (this.displaySize == DisplaySizes.S60_3_2_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_2 || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK) {
                g.setFont(this.statusSymbolFont);
                g.drawString("DEG", this.degreesRadianStatusSymbolXPos, this.statusSymbolYPos + 1, 20);
                g.setFont(this.font);
            } else if (this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
                g.setFont(this.statusSymbolFont);
                g.drawString("DEG", this.degreesRadianStatusSymbolXPos, this.statusSymbolYPos + 1, 20);
                g.setFont(this.font);
            }
        } else if (this.displaySize == DisplaySizes.DOUGLAS_8 || this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD) {
            g.setFont(this.statusSymbolFont);
            g.drawString("RAD", this.degreesRadianStatusSymbolXPos, this.statusSymbolYPos + 1, 20);
            g.setFont(this.font);
        } else if (this.displaySize == DisplaySizes.S60_3_2_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_2 || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK) {
            g.setFont(this.statusSymbolFont);
            g.drawString("RAD", this.degreesRadianStatusSymbolXPos, this.statusSymbolYPos + 1, 20);
            g.setFont(this.font);
        } else if (this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
            g.setFont(this.statusSymbolFont);
            g.drawString("RAD", this.degreesRadianStatusSymbolXPos, this.statusSymbolYPos + 1, 20);
            g.setFont(this.font);
        }
        if (this.openParentheses > 0) {
            if (this.displaySize == DisplaySizes.DOUGLAS_8 || this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD) {
                g.setFont(this.statusSymbolFont);
                g.drawString("()", this.parenthesesStatusSymbolXPos, this.statusSymbolYPos, 20);
                g.setFont(this.font);
            } else if (this.displaySize == DisplaySizes.S60_3_2_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_2 || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK) {
                g.setFont(this.statusSymbolFont);
                g.drawString("()", this.parenthesesStatusSymbolXPos, this.statusSymbolYPos, 20);
                g.setFont(this.font);
            } else if (this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
                g.setFont(this.statusSymbolFont);
                g.drawString("()", this.parenthesesStatusSymbolXPos, this.statusSymbolYPos, 20);
                g.setFont(this.font);
            }
        }
        if (this.currentState == 0) {
            int statusSymbolYPosTemp = this.statusSymbolYPos;
            if (this.displaySize == DisplaySizes.DOUGLAS_8 || this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD || this.displaySize == DisplaySizes.S60_3_2_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_2 || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
                statusSymbolYPosTemp += 10;
            }
            if (this.rows.size() > this.maximumNumberOfConcurrentlyVisibleRows && this.firstVisibleRowIndex > 0) {
                this.arrowStatusSymbol.setTransform(0);
                this.arrowStatusSymbol.setPosition(this.upArrowStatusSymbolXPos, statusSymbolYPosTemp);
                this.arrowStatusSymbol.paint(g);
            }
            if (this.rows.size() > this.maximumNumberOfConcurrentlyVisibleRows && this.lastVisibleRowIndex < this.rows.size() - 1) {
                this.arrowStatusSymbol.setTransform(3);
                this.arrowStatusSymbol.setPosition(this.downArrowStatusSymbolXPos, statusSymbolYPosTemp);
                this.arrowStatusSymbol.paint(g);
            }
        }
    }

    private void drawTerm(Graphics g) {
        block5: {
            int termYPosTemp;
            StringBuffer currentRow;
            block4: {
                currentRow = null;
                termYPosTemp = this.termYPos;
                if (this.font != null) {
                    g.setFont(this.font);
                }
                if (this.currentState != 0) break block4;
                for (int i = this.firstVisibleRowIndex; i < this.firstVisibleRowIndex + this.maximumNumberOfConcurrentlyVisibleRows && i != this.rows.size(); ++i) {
                    currentRow = (StringBuffer)this.rows.elementAt(i);
                    g.drawString(Tools.getInstance().replaceDecimalSeparator(currentRow.toString()), this.termXPos, termYPosTemp, 20);
                    termYPosTemp += this.font.getHeight() + this.termYSpacing;
                }
                break block5;
            }
            if (this.currentState != 1) break block5;
            for (int i = this.rows.size() - this.maximumNumberOfConcurrentlyVisibleRows + 1; i < this.rows.size(); ++i) {
                if (i < 0) {
                    i = 0;
                }
                currentRow = (StringBuffer)this.rows.elementAt(i);
                g.drawString(Tools.getInstance().replaceDecimalSeparator(currentRow.toString()), this.termXPos, termYPosTemp, 20);
                termYPosTemp += this.font.getHeight() + this.termYSpacing;
            }
        }
    }

    private void drawResult(Graphics g) {
        if (this.currentState == 1) {
            g.setFont(this.font);
            g.drawLine(this.resultLineXPos1, this.resultLineYPos, this.resultLineXPos2, this.resultLineYPos);
            g.drawString("=", this.resultOperatorXPos, this.resultOperatorYPos, 20);
            g.drawString(Tools.getInstance().replaceDecimalSeparator(this.result), this.resultXPos, this.resultYPos, 24);
        }
    }

    private StringBuffer getCurrentRow() {
        return (StringBuffer)this.rows.elementAt(this.currentRowIndex);
    }

    private Symbol getNthLastSymbol(int n) {
        if (n <= 0) {
            return null;
        }
        if (this.term.size() < n) {
            return null;
        }
        return (Symbol)this.term.elementAt(this.term.size() - n);
    }
}

